/*
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2015
 *
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __HOST_INTERFACE_HEADER_INCLUDED__
#define __HOST_INTERFACE_HEADER_INCLUDED__

#include "cpcglob.h"
#include <stdint.h>

#define HOST_FILE_ACCESS_READ 0x0001
#define HOST_FILE_ACCESS_WRITE 0x0002

typedef intptr_t HOST_FILE_HANDLE;

typedef struct
{
	int BPP;						/* bits per colour */
	int Mask;						/* mask */
	int Shift;						/* shift */
} GRAPHICS_BUFFER_COLOUR_ELEMENT;

struct GRAPHICS_BUFFER_COLOUR_FORMAT
{
	int BPP;								/* bits per pixel (when R,G,B are combined) */
	GRAPHICS_BUFFER_COLOUR_ELEMENT Red;		/* information about red */
	GRAPHICS_BUFFER_COLOUR_ELEMENT Green;	/* information about green */
	GRAPHICS_BUFFER_COLOUR_ELEMENT Blue;	/* information about blue */
};

typedef struct
{
	int NumberOfChannels;
	int BitsPerSample;
	int Frequency;
} SOUND_PLAYBACK_FORMAT;

HOST_FILE_HANDLE Host_OpenFile(char *Filename, int Access);
void	Host_CloseFile(HOST_FILE_HANDLE);
int		Host_GetFileSize(HOST_FILE_HANDLE);
void	Host_WriteData(HOST_FILE_HANDLE, unsigned char *, unsigned long);
void	Host_ReadData(HOST_FILE_HANDLE, unsigned char *, unsigned long);


#endif
